<?php

namespace App\Models\Cargo;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Integration extends Model 
{

    protected $table = 'cargo_firms_integration';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('type', 'is_system_defined', 'is_default');
    protected $visible = array('type', 'is_system_defined', 'is_default');

    public function company()
    {
        return $this->belongsTo('App\Models\Company');
    }

}